<?php

namespace Database\Seeders;

use App\Models\ForumCategory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ForumCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'General GMod Discussion',
                'description' => 'General discussions about Garry\'s Mod',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'name' => 'Roleplay',
                'description' => 'Discussion about GMod roleplay gamemodes',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'name' => 'Addons & Development',
                'description' => 'GMod addons, scripting, and development talk',
                'order' => 3,
                'is_active' => true,
            ],
            [
                'name' => 'Servers',
                'description' => 'Server advertisements and discussions',
                'order' => 4,
                'is_active' => true,
            ],
            [
                'name' => 'Off-Topic',
                'description' => 'Discussions not directly related to GMod',
                'order' => 5,
                'is_active' => true,
            ],
        ];

        foreach ($categories as $category) {
            ForumCategory::create([
                'name' => $category['name'],
                'slug' => Str::slug($category['name']),
                'description' => $category['description'],
                'order' => $category['order'],
                'is_active' => $category['is_active'],
            ]);
        }
    }
}
